﻿using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class SendBothAppointmentsToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.PatEcResponse = VistaFakeResponses.FakeMakePatAppointmentSuccessResponse(state);
                state.ProEcResponse = VistaFakeResponses.FakeMakeProAppointmentSuccessResponse(state);
                return;
            }
            var requestKvps = new List<KeyValuePair<string, VIMTVIASchdMakeApptmakeAppointmentRequest>>();
            requestKvps.Add(new KeyValuePair<string, VIMTVIASchdMakeApptmakeAppointmentRequest>("Pat", state.PatEcRequest));
            requestKvps.Add(new KeyValuePair<string, VIMTVIASchdMakeApptmakeAppointmentRequest>("Pro", state.ProEcRequest));
            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(requestKvps, request =>
            {
                if (request.Key == "Pat" && state.PatEcRequest != null)
                    state.PatEcResponse = state.PatEcRequest.SendReceive<VIMTVIASchdMakeApptmakeAppointmentResponse>(MessageProcessType.Local);
                if (request.Key == "Pro" && state.ProEcRequest != null)
                    state.ProEcResponse = state.ProEcRequest.SendReceive<VIMTVIASchdMakeApptmakeAppointmentResponse>(MessageProcessType.Local);
            });
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
        }
    }
}
